/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

public class ViewAreaRenderer {
    public static void renderPortalArea(PortalRenderable portalRenderable, Vec3 fogColor, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean doFaceCulling, boolean doModifyColor, boolean doModifyDepth, boolean doClip) {
        PortalLike portalLike = portalRenderable.getPortalLike();
        if (doFaceCulling) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
        if (portalLike.isFuseView() && IPGlobal.maxPortalLayer != 0) {
            GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else if (!doModifyColor) {
            GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        } else {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (doModifyDepth) {
            if (portalLike.isFuseView()) {
                GlStateManager._depthMask((boolean)false);
            } else {
                GlStateManager._depthMask((boolean)true);
            }
        } else {
            GlStateManager._depthMask((boolean)false);
        }
        boolean shouldReverseCull = PortalRendering.isRenderingOddNumberOfMirrors();
        if (shouldReverseCull) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
        if (doClip) {
            if (PortalRendering.isRendering()) {
                FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), modelViewMatrix, 0.0);
            }
        } else {
            FrontClipping.disableClipping();
        }
        GlStateManager._enableDepthTest();
        CHelper.enableDepthClamp();
        ShaderInstance shader = MyRenderHelper.portalAreaShader;
        RenderSystem.setShader(() -> shader);
        shader.f_173308_.m_5679_(modelViewMatrix);
        shader.f_173309_.m_5679_(projectionMatrix);
        FrontClipping.updateClippingEquationUniformForCurrentShader(false);
        shader.m_173363_();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(fogColor, portalRenderable, CHelper.getCurrentCameraPos(), RenderStates.getPartialTick());
        shader.m_173362_();
        GlStateManager._enableCull();
        CHelper.disableDepthClamp();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._depthMask((boolean)true);
        if (shouldReverseCull) {
            MyRenderHelper.recoverFaceCulling();
        }
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
        }
        CHelper.checkGlError();
    }

    public static void buildPortalViewAreaTrianglesBuffer(Vec3 fogColor, PortalRenderable portalRenderable, Vec3 cameraPos, float tickDelta) {
        Tesselator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Vec3 originRelativeToCamera = portalRenderable.getPortalLike().getOriginPos().m_82546_(cameraPos);
        Consumer<Vec3> vertexOutput = p -> ViewAreaRenderer.putIntoVertex(bufferBuilder, p, fogColor);
        if (portalRenderable instanceof Portal) {
            Portal portal = (Portal)portalRenderable;
            portal.renderViewAreaMesh(originRelativeToCamera, vertexOutput);
        } else if (portalRenderable instanceof PortalRenderer.PortalGroupToRender) {
            PortalRenderer.PortalGroupToRender portalGroupToRender = (PortalRenderer.PortalGroupToRender)portalRenderable;
            PortalLike portalLike = portalGroupToRender.getPortalLike();
            for (Portal portal : portalGroupToRender.portals()) {
                Vec3 relativeToGroup = portal.getOriginPos().m_82546_(portalLike.getOriginPos());
                portal.renderViewAreaMesh(originRelativeToCamera.m_82549_(relativeToGroup), vertexOutput);
            }
        }
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void generateViewAreaTriangles(Portal portal, Vec3 posInPlayerCoordinate, Consumer<Vec3> vertexOutput) {
        if (portal.specialShape == null) {
            if (portal.getIsGlobal()) {
                ViewAreaRenderer.generateTriangleForGlobalPortal(vertexOutput, portal, posInPlayerCoordinate);
            } else {
                ViewAreaRenderer.generateTriangleForNormalShape(vertexOutput, portal, posInPlayerCoordinate);
            }
        } else {
            ViewAreaRenderer.generateTriangleForSpecialShape(vertexOutput, portal, posInPlayerCoordinate);
        }
    }

    public static void generateTriangleForSpecialShape(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        ViewAreaRenderer.generateTriangleSpecial(vertexOutput, portal, posInPlayerCoordinate);
    }

    public static void generateTriangleSpecial(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        GeometryPortalShape specialShape = portal.specialShape;
        assert (specialShape != null);
        specialShape.normalize(portal.width, portal.height);
        double halfWidth = portal.width / 2.0;
        double halfHeight = portal.height / 2.0;
        for (GeometryPortalShape.TriangleInPlane triangle : specialShape.triangles) {
            Vec3 a = posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(triangle.x1 * halfWidth)).m_82549_(portal.axisH.m_82490_(triangle.y1 * halfHeight));
            Vec3 b = posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(triangle.x3 * halfWidth)).m_82549_(portal.axisH.m_82490_(triangle.y3 * halfHeight));
            Vec3 c = posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(triangle.x2 * halfWidth)).m_82549_(portal.axisH.m_82490_(triangle.y2 * halfHeight));
            vertexOutput.accept(a);
            vertexOutput.accept(b);
            vertexOutput.accept(c);
        }
    }

    private static void putIntoLocalVertex(Consumer<Vec3> vertexOutput, Portal portal, Vec3 offset, Vec3 posInPlayerCoordinate, double localX, double localY) {
        vertexOutput.accept(posInPlayerCoordinate.m_82549_(portal.axisW.m_82490_(localX)).m_82549_(portal.axisH.m_82490_(localY)).m_82549_(offset));
    }

    private static void generateTriangleForNormalShape(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        double w = Math.min(portal.width, 23333.0);
        double h = Math.min(portal.height, 23333.0);
        Vec3 v0 = portal.getPointInPlaneLocal(w / 2.0 - 0.0, -h / 2.0 + 0.0);
        Vec3 v1 = portal.getPointInPlaneLocal(-w / 2.0 + 0.0, -h / 2.0 + 0.0);
        Vec3 v2 = portal.getPointInPlaneLocal(w / 2.0 - 0.0, h / 2.0 - 0.0);
        Vec3 v3 = portal.getPointInPlaneLocal(-w / 2.0 + 0.0, h / 2.0 - 0.0);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.m_82549_(posInPlayerCoordinate), v2.m_82549_(posInPlayerCoordinate), v3.m_82549_(posInPlayerCoordinate), v1.m_82549_(posInPlayerCoordinate));
    }

    private static void generateTriangleForGlobalPortal(Consumer<Vec3> vertexOutput, Portal portal, Vec3 posInPlayerCoordinate) {
        double distance;
        Vec3 cameraPosLocal = posInPlayerCoordinate.m_82490_(-1.0);
        double cameraLocalX = cameraPosLocal.m_82526_(portal.axisW);
        double cameraLocalY = cameraPosLocal.m_82526_(portal.axisH);
        double r = Minecraft.m_91087_().f_91066_.m_193772_() * 16 - 16;
        if (TransformationManager.isIsometricView) {
            r *= 2.0;
        }
        if ((distance = Math.abs(cameraPosLocal.m_82526_(portal.getNormal()))) > 200.0) {
            r = r * 200.0 / distance;
        }
        Vec3 v0 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, -r + cameraLocalY);
        Vec3 v1 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, -r + cameraLocalY);
        Vec3 v2 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, r + cameraLocalY);
        Vec3 v3 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, r + cameraLocalY);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.m_82549_(posInPlayerCoordinate), v2.m_82549_(posInPlayerCoordinate), v3.m_82549_(posInPlayerCoordinate), v1.m_82549_(posInPlayerCoordinate));
    }

    private static void putIntoVertex(BufferBuilder bufferBuilder, Vec3 pos, Vec3 fogColor) {
        bufferBuilder.m_5483_(pos.f_82479_, pos.f_82480_, pos.f_82481_).m_85950_((float)fogColor.f_82479_, (float)fogColor.f_82480_, (float)fogColor.f_82481_, 1.0f).m_5752_();
    }

    private static void putIntoQuad(Consumer<Vec3> vertexOutput, Vec3 a, Vec3 b, Vec3 c, Vec3 d) {
        vertexOutput.accept(b);
        vertexOutput.accept(c);
        vertexOutput.accept(d);
        vertexOutput.accept(d);
        vertexOutput.accept(a);
        vertexOutput.accept(b);
    }
}

